package ohd.hseb.hefs.utils.jtree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

import javax.swing.tree.TreePath;

public class TransferableTreePaths implements Transferable
{

    public static DataFlavor TREE_PATH_FLAVOR = new DataFlavor(TreePath.class, "Tree Path");

    private final DataFlavor _flavors[] = {TREE_PATH_FLAVOR};

    private final TreePath[] _paths;

    public TransferableTreePaths(TreePath[] tp)
    {
        _paths = tp;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors()
    {
        return _flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor)
    {
        return (flavor.getRepresentationClass() == TreePath.class);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException
    {
        if(isDataFlavorSupported(flavor))
        {
            return _paths;
        }
        else
        {
            throw new UnsupportedFlavorException(flavor);
        }
    }
}
