package ohd.hseb.hefs.utils.jtree;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/**
 * Source used within the DragAndDropJTree that sees drag attempts and creates a TransferableTreeNode accordingly.
 * 
 * @author hank.herr
 */
public class TreeDragSource implements DragSourceListener, DragGestureListener
{

    private final DragSource _source;

    @SuppressWarnings("unused")
    private final DragGestureRecognizer _recognizer;

    @SuppressWarnings("unused")
    private DefaultMutableTreeNode _oldNode;

    private final JTree _sourceTree;

    public TreeDragSource(JTree tree, int actions)
    {
        _sourceTree = tree;
        _source = new DragSource();
        _recognizer = _source.createDefaultDragGestureRecognizer(_sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge)
    {
        TreePath[] paths = _sourceTree.getSelectionPaths();
        if(paths == null)
        {
            // We can't move the root node or an empty selection
            return;
        }

        //Determine moved paths as a subset of the selected paths.
        List<TreePath> movedPaths = new ArrayList<TreePath>();
        for(int i = 0; i < paths.length; i++)
        {
            //Only move path if it is a leaf and not the root (subsumed by first condition most likely, 
            //but just in case...)
            if((((DefaultMutableTreeNode)paths[i].getLastPathComponent()).isLeaf()) && (paths[i].getPathCount() > 1))
            {
                movedPaths.add(paths[i]);
            }
        }

        //If any paths to move were found, construct the transferable object.
        if(movedPaths.size() > 0)
        {
            TreePath[] movedPathsArray = new TreePath[movedPaths.size()];
            for(int i = 0; i < movedPaths.size(); i++)
            {
                movedPathsArray[i] = movedPaths.get(i);
            }
            TransferableTreePaths transferable = new TransferableTreePaths(movedPathsArray);
            _source.startDrag(dge, null, transferable, this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde)
    {
    }

    @Override
    public void dragExit(DragSourceEvent dse)
    {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde)
    {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde)
    {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde)
    {
    }
}