package ohd.hseb.hefs.utils.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

import junit.framework.TestCase;
import ohd.hseb.util.Logger;

public class ExecuteProcessUtilities extends TestCase
{
    File _executeDir = null;
    ProcessBuilder _builder;
    Logger _logger;

    public ExecuteProcessUtilities(String[] argsToInvokeExe, Logger logger)
    {
        _logger = logger;
        _builder = new ProcessBuilder(argsToInvokeExe);
    }

    public ExecuteProcessUtilities(String[] argsToInvokeExe)
    {
        _builder = new ProcessBuilder(argsToInvokeExe);
    }

    public ExecuteProcessUtilities(String rootDir, String[] argsToInvokeExe, String scenarioName, Logger logger)
    {
        _executeDir = new File(rootDir);
        _logger = logger;
        createProcess(argsToInvokeExe, scenarioName);
    }

    public void createProcess(String[] argsToInvokeExe, String scenarioName)
    {
         

        _builder = new ProcessBuilder(argsToInvokeExe);
        System.out.println("PWD:" + _executeDir.getAbsolutePath());
        _builder.directory(_executeDir);

        Map<String, String> env = _builder.environment();
        env.put("ens_dir", _executeDir.getAbsolutePath() + "/" + argsToInvokeExe[0] + "/" + scenarioName + "/");

        System.out.println("Excecuting the following command: " + argsToInvokeExe[0] + " " + argsToInvokeExe[1]);
        System.out.println("Dir executed from:" + _executeDir.getAbsolutePath());

        System.out.println("Env variables:" + env.keySet().toString());

        //UtilitiesForTesting.prepareDir(env.get("ens_dir") + "/output");

    }

    public void setLoggerToProcess(Logger logger)
    {
        _logger = logger;
    }

    public ProcessBuilder getProcess()
    {
        return _builder;
    }

    public static void writeInputStreamToStandardOut(final InputStream stream)
    {
        final InputStreamReader reader = new InputStreamReader(stream);
        final BufferedReader bufferedReader = new BufferedReader(reader);

        //Loop through stdout until its null or an IOException occur.
        try
        {
            //Read the initial line and loop through it line by line.
            String currentLine = bufferedReader.readLine();

            while(currentLine != null)
            {
               // System.out.println("Current line:" + currentLine);

                //Read the next line.
                currentLine = bufferedReader.readLine();
            }
        }
        catch(final IOException ioe)
        {
            System.out.println("Exception in reading the process output/error stream:" + ioe.getMessage());
        }
    }

    public static void writeInputStreamToFile(final InputStream stream, String fileName)
    {
        final InputStreamReader reader = new InputStreamReader(stream);
        final BufferedReader bufferedReader = new BufferedReader(reader);

        //Loop through stdout until its null or an IOException occur.
        try
        {
            OutputStream outputStream = new FileOutputStream(fileName);
            Writer writer = new OutputStreamWriter(outputStream);

            //Read the initial line and loop through it line by line.
            String currentLine = bufferedReader.readLine();

            while(currentLine != null)
            {
                writer.write(currentLine);
                writer.append('\n');

                //Read the next line.
                currentLine = bufferedReader.readLine();

            }
            writer.flush();
            writer.close();
        }
        catch(final IOException ioe)
        {
            System.out.println("Exception in reading the process output/error stream:" + ioe.getMessage());
        }
    }

    /**
     * This creates the octal dump file of seq.bin file in the same dir. If input file is "abc" then the octal dump
     * output file will be like "abc.od" in the same dir.
     * 
     * @param fileName
     * @throws Exception
     */
    public static void createOctalDumpOfSequentialBinaryFile(String fileName) throws Exception
    {
        String orgFileSeqBinFile = fileName;
        String octalDumpFile = fileName + ".od";

        final Runtime runTime = Runtime.getRuntime();
        Process process;
        try
        {
            String executionStr = "/usr/bin/od " + orgFileSeqBinFile;

            process = runTime.exec(executionStr);
            System.out.println("executionStr = "+executionStr);
            
            ExecuteProcessUtilities.writeInputStreamToFile(process.getInputStream(), octalDumpFile);
            ExecuteProcessUtilities.writeInputStreamToStandardOut(process.getErrorStream());

            if(process.waitFor() == 0)
            {
                System.out.println("od command executed successfully ");
            }
            else
            {
                System.out.println("od command failed");
            }

        }
        catch(IOException e)
        {
            e.printStackTrace();
        	throw new IOException(e.getMessage());
        }

    }

    public static void createDirs(final String dirName)
    {
        final File dir = new File(dirName);
        dir.mkdirs();
    }

}
