package ohd.hseb.hefs.utils.junit;

import java.util.Collection;
import java.util.Iterator;

import junit.framework.TestCase;
import ohd.hseb.hefs.utils.tools.NumberTools;

/**
 * General JUnit test tools.
 * 
 * @author hankherr
 */
public abstract class GeneralTestTools extends TestCase
{

    /**
     * General tool to compare two collections and make sure all values are within a level of tolerance of each other.
     * The arrays are checked as is (they are not sorted). This will call {@link #fail(String)} if the arrays do not
     * match.<br>
     * <br>
     * This does not make use of {@link NumberTools#nearEquals(Iterable, Iterable, double)} because it identifies which
     * specific number and its index in the list is different. Instead, it calls
     * {@link NumberTools#nearEquals(Number, Number, double)}.
     * 
     * @param message Error message prefix to output.
     * @param collection1 First collection, where elements are of a type that extends {@link Number}.
     * @param collection2 Second collection, where elements are of a type that extends {@link Number}.
     * @param tolerance Allowed difference (inclusive).
     */
    public static <E extends Number, F extends Number> void assertNumberCollectionsEqual(final String message,
                                                                                         final Collection<E> collection1,
                                                                                         final Collection<F> collection2,
                                                                                         final double tolerance)
    {

        if(collection1.size() != collection1.size())
        {
            fail(message + ": Collection sizes differ.");
        }
        final Iterator<E> iter1 = collection1.iterator();
        final Iterator<F> iter2 = collection2.iterator();
        int count = 0;
        while(iter1.hasNext())
        {
            final Number num1 = iter1.next();
            final Number num2 = iter2.next();
            if(!NumberTools.nearEquals(num1, num2, tolerance))
            {
                fail(message + ": values at index " + count + " differ by more than " + tolerance + " (values are "
                    + num1 + " and " + num2 + ")");
            }
            count++;
        }
    }
}
