package ohd.hseb.hefs.utils.log4j;


import java.io.Serializable;

//import org.apache.log4j.ConsoleAppender;
//import org.apache.log4j.PatternLayout;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;


/**
 * {@link ConsoleAppender} implementation of {@link OHDLog4jAppender}. It does not do anything in its
 * {@link #forceClose()} method.
 * 
 * @author hankherr, freddy.camacho
 */
public class OHDConsoleAppender implements Appender, OHDLog4jAppender
{
	
	ConsoleAppender _consoleAppender;
	
	/**
	 * Default to system.out 
	 * @param layout 
	 */
    public OHDConsoleAppender(String name, final PatternLayout layout, ConsoleAppender.Target target)
    {
    	_consoleAppender = ConsoleAppender.newBuilder()
        		.withName(name)
                .withLayout(layout)
                .setTarget(target)              
                .build();    	      
    }	

    
    public ConsoleAppender getConsoleAppender()
    {
    	return _consoleAppender;
    }
    
    @Override
    public void forceClose()
    {
        //Cannot be closed... do nothing.
    }

	@Override
	public State getState() {
		return _consoleAppender.getState();
	}

	@Override
	public void initialize() {		
		_consoleAppender.initialize();
		
	}

	@Override
	public boolean isStarted() {
		return _consoleAppender.isStarted();

	}

	@Override
	public boolean isStopped() {
		return _consoleAppender.isStopped();
	}

	@Override
	public void start() {
		_consoleAppender.start();
		
		
	}

	@Override
	public void stop() {
		_consoleAppender.stop();

		
	}

	@Override
	public void append(LogEvent arg0) {
		_consoleAppender.append(arg0);		
	}

	@Override
	public ErrorHandler getHandler() {
		return _consoleAppender.getHandler();
	}

	@Override
	public Layout<? extends Serializable> getLayout() {
		return _consoleAppender.getLayout();
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return _consoleAppender.getName();
	}

	@Override
	public boolean ignoreExceptions() {
		return _consoleAppender.ignoreExceptions();
	}

	@Override
	public void setHandler(ErrorHandler arg0) {
		_consoleAppender.setHandler(arg0);
		
	}
    
}
