package ohd.hseb.hefs.utils.log4j;

import java.io.IOException;
import java.io.Serializable;

import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

/**
 * TODO We need to determine if this class is still necessary.  It used to exist in order to ensure log files were closed upon
 * stopping an appender, but if you look over the methods now after an update to Log4j used by FEWS, they are simply pass throughs.
 * The only thing unique about this is how it constructs it, ensuring the file is written from scratch, but that can be handled
 * via a static method somewhere.  So, do we really need this class?
 * 
 * @author hank.herr
 */
public class OHDFileAppender implements Appender, OHDLog4jAppender
{

	FileAppender _fileApp;
	
    public OHDFileAppender(final String name, final Configuration config, final PatternLayout layout, final String fileName) throws IOException
    {        
        _fileApp = FileAppender.newBuilder()
        		.setConfiguration(config)
        		.withName(name)                
                .withLayout(layout)         
                .withFileName(fileName)
                .withAppend(false)  //File will not append!
                .build();  
        //_fileApp.start();
    }
    
    
    public FileAppender getFileAppender()
    {
    	return _fileApp;
    }

    @Override
    public void forceClose()
    {
        this._fileApp.stop();
    }
    
	@Override
	public State getState() {
		return _fileApp.getState();
	}

	@Override
	public void initialize() {
		_fileApp.initialize();	
	}

	@Override
	public boolean isStarted() {
		return _fileApp.isStarted();
	}

	@Override
	public boolean isStopped() {		
		return _fileApp.isStopped();
	}

	@Override
	public void start() {
		_fileApp.start();
		
	}

	@Override
	public void stop() {
		_fileApp.stop();	
	}

	@Override
	public void append(final LogEvent arg0) {
		_fileApp.append(arg0);
		
	}

	@Override
	public ErrorHandler getHandler() {
		return null;
	}

	@Override
	public Layout<? extends Serializable> getLayout() {		
		return _fileApp.getLayout();
	}

	@Override
	public String getName() {		
		return _fileApp.getName();
	}

	@Override
	public boolean ignoreExceptions() {		
		return _fileApp.ignoreExceptions();		
	}

	@Override
	public void setHandler(final ErrorHandler arg0) {
		_fileApp.setHandler(arg0);
		
	}


}
