package ohd.hseb.hefs.utils.notify;

import java.util.List;

import com.google.common.collect.Lists;

/**
 * Holds a {@link List} of event {@link Object} instances. Can be used to build up events and send them all at once.
 * 
 * @author hank.herr
 */
public class CompositeModificationNotice extends ObjectModifiedNotice
{
    private final List<Object> _events;

    /**
     * @param target The {@link Object} for which changes are being monitored.
     */
    @SuppressWarnings("unchecked")
    public CompositeModificationNotice(final Object target)
    {
        super(target, target);
        _events = Lists.newArrayList();
    }

    public void addEvent(final Object event)
    {
        _events.add(event);
    }

    public List<Object> getEvents()
    {
        return _events;
    }
}
