package ohd.hseb.hefs.utils.notify;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;

/**
 * Debugging tool: dumps events that are thrown by an {@link EventBus} to System.err.
 * 
 * @author hank.herr
 */
public class EventBusObserver
{

    private final String _name;

    public EventBusObserver(String name)
    {
        _name = name;
    }

    @Subscribe
    public void eventPosted(Object event)
    {
        System.err.println("####>> [" + _name + "] [" + System.identityHashCode(event) + "] BUS EVENT POSTED: "
            + event.getClass().getCanonicalName());
//        GeneralTools.dumpStackTrace();
    }

}
