package ohd.hseb.hefs.utils.notify;

import java.util.List;

import com.google.common.collect.Lists;

/**
 * Base class for a notice
 * 
 * @author alexander.garbarino
 */
public class Notice
{
    private final List<Notifier> _notifierHistory = Lists.newArrayList();
    private final Object _source;

    /**
     * @param source the source object which caused this notice to be generated
     */
    public Notice(Object source)
    {
        _source = source;
    }

    /**
     * @return the source object which caused this notice to be generated
     */
    public Object getSource()
    {
        return _source;
    }

    /**
     * @return a list of every object this was sent out from.
     */
    public List<Notifier> getNotifierHistory()
    {
        return _notifierHistory;
    }

    /**
     * To be called by implementing {@link NotifyingObject}s when the forward this notice.
     * 
     * @param notifier the notifying object
     */
    public void addToNotifierHistory(Notifier notifier)
    {
        _notifierHistory.add(notifier);
    }
}
