package ohd.hseb.hefs.utils.notify;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;

/**
 * A class that enables messages posted to one {@link EventBus} (implemented within {@link NotifierBase}) to be
 * forwarded to another {@link EventBus}. Use the {@link #subscribe(Notifier)} method to allow for message fowarding.
 * 
 * @author hank.herr
 */
public class NoticeForwarder extends NotifierBase
{
    /**
     * Catches all events from the {@link EventBus} to which this is subscribed and reposts them to this object's
     * {@link EventBus}.
     * 
     * @param object
     */
    @Subscribe
    public void forwardNotice(Object object)
    {
        post(object);
    }

    /**
     * Subscribes this notifier to another.
     * 
     * @param notifier
     */
    public void subscribe(Notifier notifier)
    {
        notifier.register(this);
    }

    public void subscribeAll(Iterable<? extends Notifier> notifiers)
    {
        for(Notifier notifier: notifiers)
        {
            subscribe(notifier);
        }
    }
}
