package ohd.hseb.hefs.utils.notify;

public interface Notifier
{
    /**
     * Registers {@code object}, so any appropriate events will be sent to it.<br/>
     * See {@link com.google.common.eventbus.EventBus#register(Object)} for details.
     */
    void register(Object object);

    /**
     * Unregisters {@code object), so it will no longer receive events.<br/>
     * See {@link com.google.common.eventbus.EventBus#unregister(Object)} for details.
     */
    void unregister(Object object);

    /**
     * If {@link #stopNotifying()} has been called, then begin notifying again.
     */
    void startNotifying();

    /**
     * Cause this object to stop sending out notifications.
     */
    void stopNotifying();

    /**
     * Causes this object to hold sending out notifications until {@link #releaseNotifications()} is called, when they
     * are sent out as a {@link CompositeModificationNotice}.
     */
    void holdNotifications();

    /**
     * Sends out a {@link CompositeModificationNotice} containing all the held events since the last call to
     * {@link #holdNotifications()}.
     */
    void releaseNotifications();

    public static abstract class Tools
    {
        /**
         * Registers {@code subscriber} with {@code notifier} if {@code notifier} implements {@link Notifier}.
         * 
         * @param notifier the potential notifier to subscribe to
         * @param subscriber the subscriber that will potentially receive notices
         * @return if the registration went through.
         */
        public static boolean tryRegister(Object notifier, Object subscriber)
        {
            if(notifier instanceof Notifier)
            {
                ((Notifier)notifier).register(subscriber);
                return true;
            }
            return false;
        }
    }
}
