package ohd.hseb.hefs.utils.notify;

import javax.swing.JPanel;

import com.google.common.eventbus.EventBus;

/**
 * A {@link JPanel} that has a built in {@link EventBus} instance that is initialize and with which this panel is
 * registered.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class NotifierPanel extends JPanel
{

    private EventBus _eventBus;
    {
        _eventBus = new EventBus();
        _eventBus.register(this);
    }

    /**
     * Use the {@link EventBus} provided in the passed in {@link NotifierPanel}.
     */
    public void useEventBusFromPanel(final NotifierPanel panel)
    {
        _eventBus = panel._eventBus;
        _eventBus.register(this);
    }

    /**
     * Post a notice to the internal {@link EventBus} instance.
     * 
     * @param notice
     */
    public void post(final Notice notice)
    {
        _eventBus.post(notice);
    }

}
