package ohd.hseb.hefs.utils.notify;

/**
 * For use with {@link NotifierTools} methods, this indicates that the implementing {@link Object} can be the source of
 * a {@link Notifier} and corresponding {@link NoticePoster}.
 * 
 * @author hankherr
 */
public interface NotifierProvider
{
    /**
     * @return The {@link Notifier} contained in this.
     */
    public Notifier getNotifier();

    /**
     * @return A {@link NoticePoster} that posts messages to the {@link Notifier} returned by {@link #getNotifier()}.
     */
    public NoticePoster getPoster();
}
