package ohd.hseb.hefs.utils.notify;

import java.awt.Component;

public abstract class NotifierTools
{

    /**
     * Calls {@link #registerWithParentNotifierProvider(Component, Object)}, passing in the provided component for both
     * arguments.
     */
    public static void registerWithParentNotifierProvider(final Component c)
    {
        registerWithParentNotifierProvider(c, c);
    }

    /**
     * Starting with the component itself, finds the first parent that is an instance of {@link NotifierProvider} and
     * registers the registree with it
     * 
     * @param c The {@link Component} that is the starting point for the search.
     * @param registree The object to register.
     * @throws Exception If not provider was found, an {@link IllegalStateException} is thrown.
     */
    public static void registerWithParentNotifierProvider(Component c, final Object registree)
    {
        while(c != null)
        {
            if(c instanceof NotifierProvider)
            {
                ((NotifierProvider)c).getNotifier().register(registree);
                return;
            }
            c = c.getParent();
        }
        throw new IllegalStateException("No parent instance of NotifierProvider could be found for the Component " + c);
    }

    /**
     * Starting with the component itself, finds the first parent that is an instance of {@link NotifierProvider} and
     * posts the event to its {@link NotifierProvider#getPoster()} returned object.
     * 
     * @param c The {@link Component} that is the starting point for the search.
     * @param event The {@link Object} to post, which could be a {@link Notice}.
     * @throws Exception If not provider was found, an {@link IllegalStateException} is thrown.
     */
    public static void postToParentNotifierProvider(Component c, final Object event)
    {
        while(c != null)
        {
            if(c instanceof NotifierProvider)
            {
                ((NotifierProvider)c).getPoster().post(event);
                return;
            }
            c = c.getParent();
        }
        throw new IllegalStateException("No parent instance of NotifierProvider could be found for the Component " + c);
    }
}
