package ohd.hseb.hefs.utils.notify;

import com.google.common.eventbus.Subscribe;

/**
 * Notifies that an object has been modified.<br/>
 * For this event, the {@code source} is defined to be the object which caused the {@code target} to change.
 * 
 * @author alexander.garbarino
 */
public class ObjectModifiedNotice<T> extends Notice
{
    private final T _target;

    /**
     * Sets the {@code source} to be the same as {@code target}.
     * 
     * @param sourceAndTarget
     */
    public ObjectModifiedNotice(T target)
    {
        this(null, target);
    }

    public ObjectModifiedNotice(Object source, T target)
    {
        super(source);
        _target = target;
    }

    /**
     * @return the object which was modified
     */
    public T getTarget()
    {
        return _target;
    }

    public static interface Subscriber<T>
    {
        @Subscribe
        void reactToObjectModified(ObjectModifiedNotice<T> notice);
    }
}
