package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import com.google.common.eventbus.Subscribe;

/**
 * Event signaling that multiple items were added to a collection.
 * 
 * @author alexander.garbarino
 * @param <E>
 */
public class CollectionAddAllNotice<E, T extends Collection<E>> extends CollectionModifiedNotice<E, T>
{
    private final Collection<? extends E> _addedItems;

    public CollectionAddAllNotice(Object source, T collection, Collection<? extends E> addedItems)
    {
        super(source, collection);
        _addedItems = addedItems;
    }

    public Collection<? extends E> getAddedItems()
    {
        return _addedItems;
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToCollectionAddAll(CollectionAddAllNotice<E, T> notice);
    }
}
