package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import com.google.common.eventbus.Subscribe;

/**
 * Event signaling that an item was added to a collection.
 * 
 * @author alexander.garbarino
 * @param <E>
 */
public class CollectionAddNotice<E, T extends Collection<E>> extends CollectionModifiedNotice<E, T>
{
    private final E _addedItem;

    public CollectionAddNotice(Object source, T collection, E addedItem)
    {
        super(source, collection);
        _addedItem = addedItem;
    }

    public E getAddedItem()
    {
        return _addedItem;
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToCollectionAdd(CollectionAddNotice<E, T> notice);
    }
}
