package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import ohd.hseb.hefs.utils.notify.ObjectModifiedNotice;

import com.google.common.eventbus.Subscribe;

/**
 * Event signaling that a collection was modified.
 * 
 * @author alexander.garbarino
 * @param <T>
 */
public class CollectionModifiedNotice<E, T extends Collection<E>> extends ObjectModifiedNotice<T>
{
    /**
     * @param source the object which changed the collection
     * @param collection the collection changed
     */
    public CollectionModifiedNotice(Object source, T collection)
    {
        super(source, collection);
    }

    /**
     * Alias for {@link #getTarget()}.
     */
    public T getCollection()
    {
        return getTarget();
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToCollectionModified(CollectionModifiedNotice<E, T> notice);
    }
}
