package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import com.google.common.eventbus.Subscribe;

public class CollectionRemoveAllNotice<E, T extends Collection<E>> extends CollectionModifiedNotice<E, T>
{
    private final Collection<?> _removedItems;

    public CollectionRemoveAllNotice(Object source, T collection, Collection<?> removedItems)
    {
        super(source, collection);
        _removedItems = removedItems;
    }

    public Collection<?> getRemovedItems()
    {
        return _removedItems;
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToCollectionRemoveAll(CollectionRemoveAllNotice<E, T> notice);
    }
}
