package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import com.google.common.eventbus.Subscribe;

/**
 * Event signaling that an item was removed from a collection.
 * 
 * @author alexander.garbarino
 * @param <E>
 */
public class CollectionRemoveNotice<E, T extends Collection<E>> extends CollectionModifiedNotice<E, T>
{
    private final E _removedItem;

    public CollectionRemoveNotice(Object source, T collection, E removedItem)
    {
        super(source, collection);
        _removedItem = removedItem;
    }

    public E getRemovedItem()
    {
        return _removedItem;
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToCollectionRemove(CollectionRemoveNotice<E, T> notice);
    }
}