package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import com.google.common.eventbus.Subscribe;

public class CollectionRetainAllNotice<E, T extends Collection<E>> extends CollectionModifiedNotice<E, T>
{
    private final Collection<?> _retainedItems;

    public CollectionRetainAllNotice(Object source, T collection, Collection<?> retainedItems)
    {
        super(source, collection);
        _retainedItems = retainedItems;
    }

    public Collection<?> getRetainedItems()
    {
        return _retainedItems;
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToCollectionRetainAll(CollectionRetainAllNotice<E, T> notice);
    }
}
