package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import com.google.common.eventbus.Subscribe;

/**
 * Used by a collection to notify that its elements have changed state in some way.
 * 
 * @author alexander.garbarino
 */
public class ElementsChangedNotice<E, T extends Collection<E>> extends CollectionModifiedNotice<E, T>
{
    private final Collection<? extends E> _changedElements;

    public ElementsChangedNotice(Object source, T collection, Collection<? extends E> changedElements)
    {
        super(source, collection);
        _changedElements = changedElements;
    }

    public Collection<? extends E> getChangedElements()
    {
        return _changedElements;
    }

    public static interface Subscriber<E, T extends Collection<E>>
    {
        @Subscribe
        void reactToElementsChanged(ElementsChangedNotice<E, T> notice);
    }
}
