package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;
import java.util.List;

import com.google.common.eventbus.Subscribe;

public class ListAddAllNotice<E, T extends List<E>> extends CollectionAddAllNotice<E, T>
{
    private final int _index;

    public ListAddAllNotice(Object source, T list, int index, Collection<? extends E> addedItems)
    {
        super(source, list, addedItems);
        _index = index;
    }

    public int getIndex()
    {
        return _index;
    }

    public static interface Subscriber<E, T extends List<E>>
    {
        @Subscribe
        void reactToListAddAll(ListAddAllNotice<E, T> notice);
    }
}
