package ohd.hseb.hefs.utils.notify.collect;

import java.util.List;

import com.google.common.eventbus.Subscribe;

public class ListAddNotice<E, T extends List<E>> extends CollectionModifiedNotice<E, T>
{
    private final int _index;
    private final E _element;

    public ListAddNotice(Object source, T list, int index, E element)
    {
        super(source, list);
        _index = index;
        _element = element;
    }

    public int getIndex()
    {
        return _index;
    }

    public E getElement()
    {
        return _element;
    }

    public static interface Subscriber<E, T extends List<E>>
    {
        @Subscribe
        void reactToListAdd(ListAddNotice<E, T> notice);
    }
}
