package ohd.hseb.hefs.utils.notify.collect;

import java.util.List;

import com.google.common.eventbus.Subscribe;

public class ListRemoveNotice<E, T extends List<E>> extends CollectionModifiedNotice<E, T>
{
    private final int _index;
    private final E _oldElement;

    public ListRemoveNotice(Object source, T list, int index, E oldElement)
    {
        super(source, list);
        _index = index;
        _oldElement = oldElement;
    }

    public int getIndex()
    {
        return _index;
    }

    public E getOldElement()
    {
        return _oldElement;
    }

    public static interface Subscriber<E, T extends List<E>>
    {
        @Subscribe
        void reactToListRemove(ListRemoveNotice<E, T> notice);
    }
}
