package ohd.hseb.hefs.utils.notify.collect;

import java.util.List;

import com.google.common.eventbus.Subscribe;

public class ListSetNotice<E, T extends List<E>> extends CollectionModifiedNotice<E, T>
{
    private final int _index;
    private final E _element;
    private final E _oldElement;

    public ListSetNotice(Object source, T list, int index, E element, E oldElement)
    {
        super(source, list);
        _index = index;
        _element = element;
        _oldElement = oldElement;
    }

    public int getIndex()
    {
        return _index;
    }

    public E getElement()
    {
        return _element;
    }

    public E getOldElement()
    {
        return _oldElement;
    }

    public static interface Subscriber<E, T extends List<E>>
    {
        @Subscribe
        void reactToListSet(ListSetNotice<E, T> notice);
    }
}
