package ohd.hseb.hefs.utils.notify.collect;

import java.util.Collection;

import ohd.hseb.hefs.utils.notify.Notifier;

/**
 * A collection that generates notices when it is modified.<br/>
 * Also adds methods to specify an optional source for the generated notices.
 * 
 * @author alexander.garbarino
 */
public interface NotifyingCollection<E> extends Notifier, Collection<E>
{
    boolean add(E e, Object source);

    boolean remove(Object o, Object source);

    boolean addAll(Collection<? extends E> c, Object source);

    boolean removeAll(Collection<?> c, Object source);

    boolean retainAll(Collection<?> c, Object source);

    void clear(Object source);
}
