package ohd.hseb.hefs.utils.notify.collect;

import java.util.ListIterator;

public interface NotifyingListIterator<E> extends NotifyingIterator<E>, ListIterator<E>
{
    /**
     * As {@link ListIterator#add(E)}, but specifies the source for the resulting notice.
     * 
     * @param source the event source
     */
    void add(E o, Object source);

    /**
     * As {@link ListIterator#set(E)}, but specifies the source for the resulting notice.
     * 
     * @param source the event source
     */
    void set(E o, Object source);
}
