package ohd.hseb.hefs.utils.piservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import nl.wldelft.fews.system.pi.FewsPiService;

public class FewsPiServiceAttributes
{

    /**
     * This MUST be This must be first in this file!!! This will allow the initializePreloadedAllProductsInfo method
     * which is called to initialize PRELOADED_PRODUCTS_INFO to initialize _defaultService and remember the
     * initialization. If it is below that static variable, _defaultService will be reinitialized after
     * PRELOADED_PRODUCTS_INFO is done.
     */
    private FewsPiService _defaultService = null;

    /**
     * Boolean indicates if the last attempt to connect failed. Updated whenever a reconnect is attempted. Put this
     * before _preloadedProductsInfo is initialized, so it won't be reset to false.
     */
    private boolean _lastAttemptToConnectFailed = false;

    /**
     * Records the active segment id so that the pi-service need not always be used (slowing down applications). Be sure
     * to treat null, empty, or {@link #ACTIVE_SEGMENT_NONE} as none (the PI-service surprisingly returns 'none' when no
     * active segment is available, instead of null, and {@link #ACTIVE_SEGMENT_NONE} captures that).
     */
    private String _activeSegmentId = null;

    /**
     * Records the current system time so that the pi-service need not always be used (slowing down applications).
     */
    private Date _currentSystemTime = null;

    /**
     * True if a reconnection is currently taking place. getDefaultService should wait until that reconnection is done.
     */
    private boolean _currentConnectingToPiService = false;

    /**
     * Listeners that receive messages from this provider as needed. Initialized as an empty array at creation time.
     */
    private List<FewsPiServiceProviderListener> _listeners = new ArrayList<>();

    /**
     * Records the port number, as a String, of the current connection, or nothing (empty) if connection failed.
     */
    private String _currentConnectionPortNumber = "";

    private String _currentConnectionURL = "";

    /**
     * Constructor will copy information from the provided attributes if not null. Currently, only the listeners are
     * copied.
     * 
     * @param existingAttributes Another set of attributes from which information should be copied into this one.
     */
    public FewsPiServiceAttributes(final FewsPiServiceAttributes existingAttributes)
    {
        if(existingAttributes != null)
        {
            _listeners.addAll(existingAttributes.getListeners());
        }
    }

    /**
     * @return the _defaultService
     */
    public FewsPiService getDefaultService()
    {
        return _defaultService;
    }

    /**
     * @param _defaultService the _defaultService to set
     */
    public void setDefaultService(final FewsPiService _defaultService)
    {
        this._defaultService = _defaultService;
    }

    /**
     * @return the _lastAttemptToConnectFailed
     */
    public boolean getLastAttemptToConnectFailed()
    {
        return _lastAttemptToConnectFailed;
    }

    /**
     * @param _lastAttemptToConnectFailed the _lastAttemptToConnectFailed to set
     */
    public void setLastAttemptToConnectFailed(final boolean _lastAttemptToConnectFailed)
    {
        this._lastAttemptToConnectFailed = _lastAttemptToConnectFailed;
    }

    /**
     * @return the _activeSegmentId
     */
    public String getActiveSegmentId()
    {
        return _activeSegmentId;
    }

    /**
     * @param _activeSegmentId the _activeSegmentId to set
     */
    public void setActiveSegmentId(final String _activeSegmentId)
    {
        this._activeSegmentId = _activeSegmentId;
    }

    /**
     * @return the _currentSystemTime
     */
    public Date getCurrentSystemTime()
    {
        return _currentSystemTime;
    }

    /**
     * @param _currentSystemTime the _currentSystemTime to set
     */
    public void setCurrentSystemTime(final Date _currentSystemTime)
    {
        this._currentSystemTime = _currentSystemTime;
    }

    /**
     * @return the _currentConnectingToPiService
     */
    public boolean getCurrentConnectingToPiService()
    {
        return _currentConnectingToPiService;
    }

    /**
     * @param _currentConnectingToPiService the _currentConnectingToPiService to set
     */
    public void setCurrentConnectingToPiService(final boolean _currentConnectingToPiService)
    {
        this._currentConnectingToPiService = _currentConnectingToPiService;
    }

    /**
     * @return the _listeners
     */
    public List<FewsPiServiceProviderListener> getListeners()
    {
        return _listeners;
    }

    /**
     * @param _listeners the _listeners to set
     */
    public void setListeners(final List<FewsPiServiceProviderListener> _listeners)
    {
        this._listeners = _listeners;
    }

    /**
     * @return the _currentConnectionPortNumber
     */
    public String getCurrentConnectionPortNumber()
    {
        return _currentConnectionPortNumber;
    }

    /**
     * @param _currentConnectionPortNumber the _currentConnectionPortNumber to set
     */
    public void setCurrentConnectionPortNumber(final String _currentConnectionPortNumber)
    {
        this._currentConnectionPortNumber = _currentConnectionPortNumber;
    }

    /**
     * @return the _currentConnectionURL
     */
    public String getCurrentConnectionURL()
    {
        return _currentConnectionURL;
    }

    /**
     * @param _currentConnectionURL the _currentConnectionURL to set
     */
    public void setCurrentConnectionURL(final String _currentConnectionURL)
    {
        this._currentConnectionURL = _currentConnectionURL;
    }

}
