package ohd.hseb.hefs.utils.piservice;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

//import ohd.hseb.graphgen.utils.piservice.OHDGraphGenProductsSettingsFileService;
import ohd.hseb.hefs.utils.gui.tools.SelfListeningButton;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;

public class FewsPiServiceReconnectButton extends SelfListeningButton implements FewsPiServiceProviderListener
{
    private static final long serialVersionUID = 1L;

    private final String _okIconImageName;
    private final String _errorIconImageName;
    private final JPanel _owningPanel;

    /**
     * Default constructor uses hefsIcons/server_ok.png and hefsIcons/server_error.png.
     * 
     * @param owningPanel
     */
    public FewsPiServiceReconnectButton(final JPanel owningPanel)
    {
        this(owningPanel, "hefsIcons/server_ok.png", "hefsIcons/server_error.png");
    }

    public FewsPiServiceReconnectButton(final JPanel owningPanel,
                                        final String okIconImageName,
                                        final String errorIconImageName)
    {
        _owningPanel = owningPanel;
        _okIconImageName = okIconImageName;
        _errorIconImageName = errorIconImageName;

        //The icon
        final URL url = ClassLoader.getSystemResource(okIconImageName);
        ImageIcon icon = null;
        if(url != null)
        {
            icon = new ImageIcon(url);
            setIcon(icon);
        }
        else
        {
            setText(okIconImageName + " not found");
        }

        //Tool tip
        setToolTipText("Connect to CHPS PI-service");

        //Add this as a listener to the GraphGenFewsPiServiceProvider
        FewsPiServiceProvider.addFewsPiServiceProviderListener(this);

        this.updateReconnectButtonToReflectDBAccessibility();
    }

    public void updateReconnectButtonToReflectDBAccessibility()
    {
        if(!FewsPiServiceProvider.isDefaultServiceConnected())
        {
            setIcon(SwingTools.loadImageIcon(_errorIconImageName));
        }
        else
        {
            setIcon(SwingTools.loadImageIcon(_okIconImageName));
        }
    }

    @Override
    public void reactToReinitializedPIServiceConnection()
    {
        updateReconnectButtonToReflectDBAccessibility();
    }

    @Override
    public void actionPerformed(final ActionEvent e)
    {

        final String portString = (String)JOptionPane.showInputDialog(_owningPanel,
                                                                      "Enter the port number to use to connect to the PI-service.\n"
                                                                          + "To identify the number, check the log panel at start-up for a line similar to this:\n\n"
                                                                          + "    10-14-2010 15:01:02 INFO - Started FewsPiServiceImpl on localHost : 8100\n\n"
                                                                          + "The number at the end of the line is the port number to enter here:",
                                                                      "Enter Port Number",
                                                                      JOptionPane.QUESTION_MESSAGE,
                                                                      null,
                                                                      null,
                                                                      FewsPiServiceProvider.getCurrentConnectionPortNumber());
        if((portString == null) || (portString.length() == 0))
        {
            return;
        }

        _owningPanel.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

        //Initialize the service and reload the products.  Clear the cache and then update the reconnect
        //button icon.  Note that if the service failed to connect, the reinitializePreloadedAllProductsInfo
        //will clear out the products.
        FewsPiServiceProvider.initializeDefaultService(true, portString);
        //OHDGraphGenProductsSettingsFileService.initializeDefaultService(null, null);

        //Send a message stating if the connection was established.
        if(!FewsPiServiceProvider.checkLastAttemptToConnectSuccess())
        {
            JOptionPane.showMessageDialog(_owningPanel,
                                          "A a web-service connection cannot be made to the FEWS PI-service.\nTime series and products in the CHPS database will not be available.",
                                          "Cannot Connect to the FEWS PI-service!",
                                          JOptionPane.ERROR_MESSAGE);
        }
        else
        {
            JOptionPane.showMessageDialog(_owningPanel,
                                          "Web-service connection established to the FEWS PI-service.",
                                          "Successfully Connected to the FEWS PI-service!",
                                          JOptionPane.INFORMATION_MESSAGE);
        }

        _owningPanel.setCursor(Cursor.getDefaultCursor());
    }
}
