package ohd.hseb.hefs.utils.piservice;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

import ohd.hseb.hefs.utils.gui.tools.SelfListeningButton;

public class FewsPiServiceResetConnectionButton extends SelfListeningButton
{
    private static final long serialVersionUID = 1L;

    private final JPanel _owningPanel = null;

    /**
     * Default constructor uses hefsIcons/server_ok.png and hefsIcons/server_error.png.
     * 
     * @param owningPanel
     */
    public FewsPiServiceResetConnectionButton(final JPanel owningPanel)
    {
        super("resetConnectionToServer24x24", "Reestablish connection to FEWS PI-service");

    }

    @Override
    public void actionPerformed(final ActionEvent arg0)
    {
        FewsPiServiceProvider.reinitializeDefaultService();

        //Send a message stating if the connection was established.
        if(!FewsPiServiceProvider.checkLastAttemptToConnectSuccess())
        {
            JOptionPane.showMessageDialog(_owningPanel,
                                          "A a web-service connection cannot be made to the FEWS PI-service.\nTime series and products in the CHPS database will not be available.",
                                          "Cannot Connect to the FEWS PI-service!",
                                          JOptionPane.ERROR_MESSAGE);
        }
        else
        {
            JOptionPane.showMessageDialog(_owningPanel,
                                          "Web-service connection established to the FEWS PI-service.",
                                          "Successfully Connected to the FEWS PI-service!",
                                          JOptionPane.INFORMATION_MESSAGE);
        }
    }
}
