package ohd.hseb.hefs.utils.plugins;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLWriter;

/**
 * Generic implementation of GeneralPlugInParameters.
 * 
 * @author hank.herr
 */
public abstract class DefaultPlugInParameters implements GeneralPlugInParameters
{

    private String _xmlTagName = null;
    private Boolean _statusOfLastAttemptUse = true;

    @Override
    public void setStatusOfLastAttemptToUseParameters(final Boolean b)
    {
        this._statusOfLastAttemptUse = b;
    }

    @Override
    public Boolean getStatusOfLastAttemptToUseParameters()
    {
        return this._statusOfLastAttemptUse;
    }

    @Override
    public String getXMLTagName()
    {
        return _xmlTagName;
    }

    @Override
    public void setXMLTagName(final String name)
    {
        _xmlTagName = name;
    }

    @Override
    public abstract Object clone() throws CloneNotSupportedException;

    @Override
    public void argumentsChanged()
    {
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }
}
