package ohd.hseb.hefs.utils.plugins;

import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;

/**
 * All plug-ins must implement this interface.
 * 
 * @author herrhd
 */
public interface GeneralPlugIn
{

    /**
     * @return A descriptive name for the plug-in, which may be used in menus within the GUI in the future (as of
     *         7/10/09, it is not used anywhere).
     */
    public String getDescriptiveName();

    /**
     * @throws An Exception if any parameters within the return of getParameters() are found to be invalid.
     */
    public void checkParametersForValidity() throws Exception;

    /**
     * Called to pass in an ArgumentsProcessor to the plug-in, so that it has access to user specified arguments, if
     * needed.
     * 
     * @param arguments
     */
    public void setArgumentsProcessor(ArgumentsProcessor arguments);

    /**
     * The parameters object specifying user-settings for this plug-in.
     * 
     * @return
     */
    public GeneralPlugInParameters getParameters();

    /**
     * @return An initialized instance of a parameters object for this plug-in. Note that this will return an empty
     *         instance; it does not return the actively used instance returned by getParameters().
     */
    public abstract GeneralPlugInParameters returnInitializedInstanceOfParameters();

    /**
     * @return An instance of a GraphicsGeneratorPlugInPanel that can allow users to edit the parameters object returned
     *         by getParameters().
     */
    public GeneralPlugInPanel buildPlugInPanel();

}
