package ohd.hseb.hefs.utils.plugins;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLWriter;

/**
 * A general interface for plugins that was designed for GraphicsGenerator but should be useful in general. It has
 * associated with it parameters specifying user settings. Those parameter classes must implement this interface.
 * 
 * @author herrhd
 */
public interface GeneralPlugInParameters extends XMLReader, XMLWriter, Cloneable
{
    /**
     * @return A short displayable summary of the parameters, often used in GUI to summarize the parameters to the user
     *         in a list. For most plug-in, this will not be used.
     */
    public String getShortGUIDisplayableParametersSummary();

    /**
     * Performs a deep copy.
     */
    public void copyFrom(GeneralPlugInParameters parameters);

    /**
     * Sets a tag recording the XML tag name for the parameters when written to or read from XML.
     */
    public void setXMLTagName(String name);

    @Override
    public String getXMLTagName();

    /**
     * @return Flag indicating if a plug-in executed successfully. This method should not need to be used within a
     *         plug-in. Rather, the status is set by the core code that executes the plug-in and is set to false if the
     *         plug-in throws an exception or otherwise indicates a failure.
     */
    public Boolean getStatusOfLastAttemptToUseParameters();

    /**
     * Called to set the status flag that can be referred to later to determine if the plugin executed successfully.
     * This method should not need to be called within a plug-in. It is up to the core code to set the status flag based
     * on if the plug-in throws an exception.
     * 
     * @param b
     */
    public void setStatusOfLastAttemptToUseParameters(Boolean b);

    /**
     * This will be called whenever an argument is changed. The implementer should be sure to relay the arguments
     * changed to any embedded GeneralPlugInParameters instances, as well as react itself.
     */
    public void argumentsChanged();

    /**
     * Standard clone.
     */
    public Object clone() throws CloneNotSupportedException;

    /**
     * Want to make sure equals is overridden.
     */
    @Override
    public boolean equals(Object parameters);

}
