package ohd.hseb.hefs.utils.plugins;

import ohd.hseb.hefs.utils.tools.StringTools;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class GenericParameter extends DefaultPlugInParameters
{

    public static String NULL_VALUE_STRING = "-none-";

    private String _name = "";

    private String _value = "";

    private boolean _caseSensitiveName = false;

    public GenericParameter(final String name, final String value)
    {
        setXMLTagName("parameter");
        _name = name;
        _value = value;
    }

    public GenericParameter(final String name, final String value, final boolean caseSensitiveName)
    {
        _name = name;
        _value = value;
        this._caseSensitiveName = caseSensitiveName;
    }

    public GenericParameter()
    {
    }

    public boolean isForParameter(final String name)
    {
        if(!_caseSensitiveName)
        {
            return _name.equalsIgnoreCase(name);
        }
        return _name.equals(name);
    }

    public void setName(final String name)
    {
        _name = name;
    }

    public void setValue(final String value)
    {
        _value = value;
    }

    public void setValue(final int value)
    {
        _value = "" + value;
    }

    public void setValue(final double value)
    {
        _value = "" + value;
    }

    public void setValue(final float value)
    {
        _value = "" + value;
    }

    public String getValue()
    {
        return _value;
    }

    public int getValueAsInt() throws NumberFormatException
    {
        return Integer.parseInt(_value);
    }

    public float getValueAsFloat() throws NumberFormatException
    {
        return Float.parseFloat(_value);
    }

    public double getValueAsDouble() throws NumberFormatException
    {
        return Double.parseDouble(_value);
    }

    public String getName()
    {
        return _name;
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        if(elementName.equals(getXMLTagName()))
        {
            this._name = "";
            this._value = "";
            final String idString = attr.getValue("id");
            if(idString == null)
            {
                throw new XMLReaderException("No id was provided for parameter.");
            }
            _name = idString;
        }
        return null;
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        if(elementName.equals(getXMLTagName()))
        {
            if(value.equals(NULL_VALUE_STRING))
            {
                _value = null;
            }
            else
            {
                _value = value;
            }

        }
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        String value = _value;
        if(value == null)
        {
            value = NULL_VALUE_STRING;
        }
        final Element mainElement = XMLTools.createTextNodeElement(request, getXMLTagName(), value);
        mainElement.setAttribute("id", _name);
        return mainElement;
    }

    @Override
    public String toString()
    {
        String result = "GenericParameter: ";
        result += "name = '" + _name + "'; ";
        result += "value = '" + _value + "'.";
        return result;
    }

    @Override
    public boolean equals(final Object obj)
    {
        if(!(obj instanceof ohd.hseb.hefs.utils.plugins.GenericParameter))
        {
            return false;
        }
        final GenericParameter param = (GenericParameter)obj;
        if((!this._caseSensitiveName) && (!_name.equalsIgnoreCase(param.getName())))
        {
            return false;
        }
        if((this._caseSensitiveName) && (!_name.equals(param.getName())))
        {
            return false;
        }
        if(!StringTools.checkForFullEqualityOfStrings(_value, param.getValue(), true))
        {
            return false;
        }
        if(!this.getXMLTagName().equals(param.getXMLTagName()))
        {
            return false;
        }
        return true;
    }

    @Override
    public Object clone()
    {
        final GenericParameter result = new GenericParameter(_name, _value, this._caseSensitiveName);
        result.setXMLTagName(getXMLTagName());
        return result;
    }

    @Override
    public String getShortGUIDisplayableParametersSummary()
    {
        return _name + " = " + this._value;
    }

    @Override
    public void copyFrom(final GeneralPlugInParameters parameters)
    {
        final GenericParameter base = (GenericParameter)parameters;
        this._name = base.getName();
        this._value = base.getValue();
    }
}
