package ohd.hseb.hefs.utils.plugins;

import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;

/**
 * Generic panel meant to modify the value of a GenericParameter within a GenericParameterList for which the value is
 * processed as an integer. Parameter changed events will be fired whenever the value is changed or if the parameter is
 * removed/added to the list.
 * 
 * @author hank.herr
 */
public class IntegerGenericParameterPanel extends GeneralPlugInPanel implements ItemListener, ChangeListener
{
    private static final long serialVersionUID = 1L;

    private final JCheckBox _includeInListCheckBox = HSwingFactory.createJCheckBox("Override Parameter", null, false);
    private JSpinner _valueSpinner;
    private String _nameOfParameterToManage;

    //Need to suppress the warning for now.  Eventually, I may end up using arguments, but for now, no.
    @SuppressWarnings("unused")
    private ArgumentsProcessor _argumentsProcessor;

    public IntegerGenericParameterPanel()
    {

    }

    public IntegerGenericParameterPanel(GeneralPlugInParameters parameters,
                                        ArgumentsProcessor argProc,
                                        String nameOfParameterToManage)
    {
        this.setManagedParameters(parameters);
        _argumentsProcessor = argProc;
        _nameOfParameterToManage = nameOfParameterToManage;
        createDisplay();
        makePanelReflectParameters();
    }

    public void createDisplay()
    {
        _valueSpinner = HSwingFactory.createJSpinner(null, 5, 0, null, null, 1);

        //Wrapped in html so that it can be disabled while leaving the text black.
        _includeInListCheckBox.setText("<html>Override " + _nameOfParameterToManage + "</html>");
    }

    protected void makePanelReflectParameters()
    {
        _includeInListCheckBox.removeItemListener(this);
        _valueSpinner.removeChangeListener(this);

        GenericParameter existingParameter = ((GenericParameterList)this.getManagedParameters()).getParameterWithName(this._nameOfParameterToManage);
        if(existingParameter != null)
        {
            _includeInListCheckBox.setSelected(true);
            this._valueSpinner.setValue(Integer.parseInt(existingParameter.getValue()));
        }
        else
        {
            _includeInListCheckBox.setSelected(false);
            this._valueSpinner.setValue(-1);
        }

        _includeInListCheckBox.addItemListener(this);
        _valueSpinner.addChangeListener(this);
    }

    protected void makeParametersReflectPanel()
    {
        if(!this._includeInListCheckBox.isSelected())
        {
            getParameterList().removeParameters(this._nameOfParameterToManage);
        }
        else
        {
            if(getEditedParameter() == null)
            {
                getParameterList().addParameter(this._nameOfParameterToManage, "" + _valueSpinner.getValue());
            }
            else
            {
                getEditedParameter().setValue("" + _valueSpinner.getValue());
            }
        }
    }

    public void disableCheckBox()
    {
        this._includeInListCheckBox.setEnabled(false);
    }

    public JCheckBox getIncludeInListCheckBox()
    {
        return this._includeInListCheckBox;
    }

    public JPanel getEditingDisplayPanel()
    {
        JPanel result = new JPanel(new FlowLayout(FlowLayout.LEFT));
        result.add(_valueSpinner);
        return result;
    }

    public JSpinner getValueSpinner()
    {
        return _valueSpinner;
    }

    protected void setNameOfParameterToManage(String name)
    {
        this._nameOfParameterToManage = name;
    }

    protected String getNameOfParameterToManage()
    {
        return this._nameOfParameterToManage;
    }

    public GenericParameterList getParameterList()
    {
        return (GenericParameterList)this.getManagedParameters();
    }

    public GenericParameter getEditedParameter()
    {
        return getParameterList().getParameterWithName(_nameOfParameterToManage);
    }

    public String getCurrentValueOfManagedParameter()
    {
        if(getEditedParameter() == null)
        {
            return null;
        }
        return getEditedParameter().getValue();
    }

    private boolean hasParameterBeenChanged()
    {
        return !(this._valueSpinner.getValue().equals(getCurrentValueOfManagedParameter()));
    }

    @Override
    public void disableSubPanel()
    {
        this._includeInListCheckBox.setEnabled(false);
        this._valueSpinner.setEnabled(false);
    }

    @Override
    public void enableSubPanel()
    {
        this._includeInListCheckBox.setEnabled(true);
        this._valueSpinner.setEnabled(true);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0)
    {
        if(this.hasParameterBeenChanged())
        {
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e)
    {
        if(e.getSource() == this._valueSpinner)
        {
            if(this.hasParameterBeenChanged())
            {
                makeParametersReflectPanel();
                fireParametersChanged();
            }
        }
    }

}
