package ohd.hseb.hefs.utils.plugins;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ohd.hseb.hefs.utils.arguments.ArgumentInsertingTextField;
import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;

/**
 * Generic panel meant to modify the value of a GenericParameter within a GenericParameterList for which the value is
 * processed as text. Parameter changed events will be fired whenever the value is changed or if the parameter is
 * removed/added to the list.
 * 
 * @author hank.herr
 */
public class TextGenericParameterPanel extends GeneralPlugInPanel implements ItemListener, ActionListener,
FocusListener, KeyListener
{
    private static final long serialVersionUID = 1L;

    private final JCheckBox _includeInListCheckBox = HSwingFactory.createJCheckBox("Override Parameter", null, false);
    private JTextField _valueTextField = null;
    private final JButton _setToDefaultButton = HSwingFactory.createJButton("Set to Default", null, this);
    private String _nameOfParameterToManage;
    private String _argumentNameOfPredefinedDefault;
    private boolean _defaultValueIsArgument = true;
    private ArgumentsProcessor _argumentsProcessor;

    public TextGenericParameterPanel()
    {

    }

    public TextGenericParameterPanel(final GeneralPlugInParameters parameters,
                                     final ArgumentsProcessor argProc,
                                     final String nameOfParameterToManage,
                                     final String defaultArgumentName)
    {
        this.setManagedParameters(parameters);
        _argumentsProcessor = argProc;
        _nameOfParameterToManage = nameOfParameterToManage;
        _argumentNameOfPredefinedDefault = defaultArgumentName;
        createDisplay();
        makePanelReflectParameters();
    }

    public TextGenericParameterPanel(final GeneralPlugInParameters parameters,
                                     final ArgumentsProcessor argProc,
                                     final String nameOfParameterToManage,
                                     final String defaultArgumentName,
                                     final boolean defaultValueIsAnArgument)
    {
        this.setManagedParameters(parameters);
        this._defaultValueIsArgument = defaultValueIsAnArgument;
        _argumentsProcessor = argProc;
        _nameOfParameterToManage = nameOfParameterToManage;
        _argumentNameOfPredefinedDefault = defaultArgumentName;
        createDisplay();
        makePanelReflectParameters();
    }

    public void createDisplay()
    {
        _valueTextField = new ArgumentInsertingTextField(_argumentsProcessor);
        _valueTextField.setColumns(15);

        //Wrapped in html so that it can be disabled while leaving the text black.
        _includeInListCheckBox.setText("<html>Override " + _nameOfParameterToManage + "</html>");
    }

    protected void makePanelReflectParameters()
    {
        _includeInListCheckBox.removeItemListener(this);
        _valueTextField.removeActionListener(this);
        _valueTextField.removeFocusListener(this);
        _valueTextField.removeKeyListener(this);

        final GenericParameter existingParameter = this.getEditedParameter();
        if(existingParameter != null)
        {
            _includeInListCheckBox.setSelected(true);
            _valueTextField.setText(existingParameter.getValue());
        }
        else
        {
            _includeInListCheckBox.setSelected(false);
            _valueTextField.setText("");
        }
        determineBackGroundOfTextField();

        _includeInListCheckBox.addItemListener(this);
        _valueTextField.addActionListener(this);
        _valueTextField.addFocusListener(this);
        _valueTextField.addKeyListener(this);
    }

    private void determineBackGroundOfTextField()
    {
        if((this._includeInListCheckBox.isSelected() && (_valueTextField.getText().trim().length() == 0)))
        {
            this._valueTextField.setBackground(new Color(255, 192, 192));
        }
        else
        {
            this._valueTextField.setBackground(Color.WHITE);
        }
    }

    protected void makeParametersReflectPanel()
    {
        if(!this._includeInListCheckBox.isSelected())
        {
            getParameterList().removeParameters(this._nameOfParameterToManage);
        }
        else
        {
            if(getEditedParameter() == null)
            {
                getParameterList().addParameter(this._nameOfParameterToManage, this._valueTextField.getText());
            }
            else
            {
                getEditedParameter().setValue(this._valueTextField.getText());
            }
        }
    }

    public void disableCheckBox()
    {
        this._includeInListCheckBox.setEnabled(false);
    }

    public void forceCheckIncludeInListCheckBox()
    {
        if(!this._includeInListCheckBox.isSelected())
        {
            this._includeInListCheckBox.setSelected(true);
        }
    }

    public JCheckBox getIncludeInListCheckBox()
    {
        return this._includeInListCheckBox;
    }

    public JPanel getEditingDisplayPanel()
    {
        final JPanel result = new JPanel(new FlowLayout(FlowLayout.LEFT));
        result.add(_valueTextField);
        if(this._argumentNameOfPredefinedDefault != null)
        {
            result.add(this._setToDefaultButton);
        }
        return result;
    }

    public JTextField getValueTextField()
    {
        return _valueTextField;
    }

    public GenericParameterList getParameterList()
    {
        return (GenericParameterList)this.getManagedParameters();
    }

    public GenericParameter getEditedParameter()
    {
        return getParameterList().getParameterWithName(_nameOfParameterToManage);
    }

    public String getCurrentValueOfManagedParameter()
    {
        if(getEditedParameter() == null)
        {
            return null;
        }
        return getEditedParameter().getValue();
    }

    private boolean hasParameterBeenChanged()
    {
        return !(this._valueTextField.getText().equals(getCurrentValueOfManagedParameter()));
    }

    protected void setNameOfParameterToManage(final String name)
    {
        this._nameOfParameterToManage = name;
    }

    protected String getNameOfParameterToManage()
    {
        return this._nameOfParameterToManage;
    }

    protected void setArgumentNameOfPredefinedDefault(final String name)
    {
        this._argumentNameOfPredefinedDefault = name;
    }

    public String getArgumentNameOfPredefinedDefault()
    {
        return this._argumentNameOfPredefinedDefault;
    }

    @Override
    public void disableSubPanel()
    {
        this._includeInListCheckBox.setEnabled(false);
        this._valueTextField.setEnabled(false);
        this._setToDefaultButton.setEnabled(false);
    }

    @Override
    public void enableSubPanel()
    {
        this._includeInListCheckBox.setEnabled(true);
        this._valueTextField.setEnabled(true);
        this._setToDefaultButton.setEnabled(true);
    }

    @Override
    public void itemStateChanged(final ItemEvent arg0)
    {
        this.determineBackGroundOfTextField();
        this.makeParametersReflectPanel();
        this.fireParametersChanged();
    }

    @Override
    public void actionPerformed(final ActionEvent arg0)
    {
        if(arg0.getSource() == this._setToDefaultButton)
        {
            if(_defaultValueIsArgument)
            {
                _valueTextField.setText(""
                    + ArgumentsProcessor.argumentizeParameterName(_argumentNameOfPredefinedDefault));
            }
            else
            {
                _valueTextField.setText(_argumentNameOfPredefinedDefault);
            }
        }

        if(hasParameterBeenChanged())
        {
            this.determineBackGroundOfTextField();
            this.makeParametersReflectPanel();
            this.fireParametersChanged();
        }
    }

    @Override
    public void focusGained(final FocusEvent e)
    {
    }

    @Override
    public void focusLost(final FocusEvent e)
    {
        if(e.getSource() == this._valueTextField)
        {
            if(hasParameterBeenChanged())
            {
                makeParametersReflectPanel();
                fireParametersChanged();
            }
        }
    }

    @Override
    public void keyPressed(final KeyEvent e)
    {
    }

    @Override
    public void keyReleased(final KeyEvent e)
    {
        determineBackGroundOfTextField();
    }

    @Override
    public void keyTyped(final KeyEvent e)
    {
    }

}
