package ohd.hseb.hefs.utils.rc;

import ohd.hseb.hefs.utils.xml.CompositeXMLReader;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLWritable;
import ohd.hseb.hefs.utils.xml.XMLWriter;

/**
 * A {@link HRatingCurve} contains a {@link HRatingCurveHeader} and a {@link HRatingCurveTable}.
 * 
 * @author hankherr
 */
public class HRatingCurve implements XMLReadable, XMLWritable
{

    private HRatingCurveHeader _header = new HRatingCurveHeader();
    private HRatingCurveTable _table = new HRatingCurveTable();

    public HRatingCurve()
    {
    }

    /**
     * Only used internally via {@link #createNewContainer()}, this version allows for the {@link #_header} and
     * {@link #_table} to be specified externally.
     */
    private HRatingCurve(final HRatingCurveHeader header, final HRatingCurveTable table)
    {
        _header = header;
        _table = table;
    }

    public HRatingCurveHeader getHeader()
    {
        return _header;
    }

    public HRatingCurveTable getTable()
    {
        return _table;
    }

    /**
     * Override as needed if this rating curve is to be added to a list of rating curves after reading, making use of
     * {@link #createNewContainer()} and {@link #clear()}. By default, this method does nothing.
     */
    protected void finalizeReading()
    {
    }

    /**
     * @return A new {@link HRatingCurve} that contains the same {@link #_header} and {@link #_table} objects as this one
     *         when the method was called. After creating the new instance, this {@link HRatingCurve} will be reset to
     *         have a new {@link #_header} and {@link #_table}.
     */
    protected HRatingCurve moveRatingCurveInfoIntoNewInstance()
    {
        final HRatingCurve returnValue = new HRatingCurve(_header, _table);
        _header = new HRatingCurveHeader();
        _table = new HRatingCurveTable();
        return returnValue;
    }

    @Override
    public XMLReader getReader()
    {
        return new CompositeXMLReader("ratingCurve", _header, _table)
        {
            @Override
            public void finalizeReading() throws XMLReaderException
            {
                super.finalizeReading();
                HRatingCurve.this.finalizeReading();
            }
        };
    }

    @Override
    public XMLWriter getWriter()
    {
        return new CompositeXMLWriter("ratingCurve", _header, _table);
    }

}
