package ohd.hseb.hefs.utils.rc;

import java.util.ArrayList;
import java.util.List;

import ohd.hseb.hefs.utils.xml.CompositeXMLReader;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLWritable;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.vars.XMLFixedDate;
import ohd.hseb.hefs.utils.xml.vars.XMLMeasuringUnit;
import ohd.hseb.hefs.utils.xml.vars.XMLString;
import ohd.hseb.measurement.MeasuringUnit;

import com.google.common.collect.Lists;

/**
 * Stores information in the header of a rating curve. The reader and writer does not care about required/non-required
 * values.
 * 
 * @author hankherr
 */
public class HRatingCurveHeader implements XMLWritable, XMLReadable
{

    private final XMLString _locationId = new XMLString("locationId");
    private final List<XMLString> _qualifierIdList = new ArrayList<>();
    private final XMLFixedDate _startDate = new XMLFixedDate("startDate");
    private final XMLFixedDate _endDate = new XMLFixedDate("endDate");
    private final XMLString _longName = new XMLString("longName");
    private final XMLString _stationName = new XMLString("stationName");
    private final XMLMeasuringUnit _stageUnit = new XMLMeasuringUnit("stageUnit");
    private final XMLMeasuringUnit _dischargeUnit = new XMLMeasuringUnit("dischargeUnit");
    private final XMLString _sourceOrganization = new XMLString("sourceOrganisation");
    private final XMLString _sourceSystem = new XMLString("sourceSystem");
    private final XMLString _fileDescription = new XMLString("fileDescription");
    private final XMLString _comment = new XMLString("comment");
    private final XMLString _creationDate = new XMLString("creationDate");
    private final XMLString _creationTime = new XMLString("creationTime");
    private final XMLString _region = new XMLString("region");

    public HRatingCurveHeader()
    {
    }

    public String getLocationId()
    {
        return _locationId.get();
    }

    public void setLocationId(final String locationId)
    {
        _locationId.set(locationId);
    }

    public Long getStartDate()
    {
        return _startDate.get();
    }

    public void setStartDate(final Long startDate)
    {
        _startDate.set(startDate);
    }

    public Long getEndDate()
    {
        return _endDate.get();
    }

    public void setEndDate(final Long date)
    {
        _endDate.set(date);
    }

    public String getStationName()
    {
        return _stationName.get();
    }

    public void setStationName(final String stationName)
    {
        _stationName.set(stationName);
    }

    public String getLongName()
    {
        return _longName.get();
    }

    public void setLongName(final String name)
    {
        _longName.set(name);
    }

    public MeasuringUnit getStageUnit()
    {
        return _stageUnit.get();
    }

    public void setStageUnit(final MeasuringUnit unit)
    {
        _stageUnit.set(unit);
    }

    public MeasuringUnit getDischargeUnit()
    {
        return _dischargeUnit.get();
    }

    public void setDischargeUnit(final MeasuringUnit unit)
    {
        _dischargeUnit.set(unit);
    }

    public String getSourceOrganization()
    {
        return _sourceOrganization.get();
    }

    public void setSourceOrganization(final String source)
    {
        _sourceOrganization.set(source);
    }

    public String getSourceSystem()
    {
        return _sourceSystem.get();
    }

    public void setSourceSystem(final String source)
    {
        _sourceSystem.set(source);
    }

    public String getFileDescriptionSystem()
    {
        return _fileDescription.get();
    }

    public void setFileDescription(final String text)
    {
        _fileDescription.set(text);
    }

    public String getComment()
    {
        return _comment.get();
    }

    public void setComment(final String text)
    {
        _comment.set(text);
    }

    public String getCreationDate()
    {
        return _creationDate.get();
    }

    public void setCreationDate(final String text)
    {
        _creationDate.set(text);
    }

    public String getCreationTime()
    {
        return _creationTime.get();
    }

    public void setCreationTime(final String text)
    {
        _creationTime.set(text);
    }

    public String getRegion()
    {
        return _region.get();
    }

    public void setRegion(final String text)
    {
        _region.set(text);
    }

    @Override
    public XMLWriter getWriter()
    {
        final List<XMLWritable> toWrite = Lists.newArrayList((XMLWritable)_locationId);
        toWrite.addAll(_qualifierIdList);
        toWrite.addAll(Lists.newArrayList((XMLWritable)_startDate,
                                          _endDate,
                                          _longName,
                                          _stationName,
                                          _stageUnit,
                                          _dischargeUnit,
                                          _sourceOrganization,
                                          _sourceSystem,
                                          _fileDescription,
                                          _comment,
                                          _creationDate,
                                          _creationTime,
                                          _region));
        return new CompositeXMLWriter("header", toWrite);
    }

    @Override
    public XMLReader getReader()
    {
        //When a qualifierId is found and processed, it is added to the _qualifierIdList.
        return new CompositeXMLReader("header",
                                      _locationId,
                                      new XMLString("qualifierId")
                                      {
                                          @Override
                                          public void finalizeReading() throws XMLReaderException
                                          {
                                              _qualifierIdList.add(new XMLString("qualifierId", this.get()));
                                          }
                                      },
                                      _startDate,
                                      _endDate,
                                      _longName,
                                      _stationName,
                                      _stageUnit,
                                      _dischargeUnit,
                                      _sourceOrganization,
                                      _sourceSystem,
                                      _fileDescription,
                                      _comment,
                                      _creationDate,
                                      _creationTime,
                                      _region);
    }

}
