package ohd.hseb.hefs.utils.regularts;

import java.util.ArrayList;
import java.util.List;

import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.fews.FewsRegularTimeSeries;

public abstract class RegularTimeSeriesTools
{

    /**
     * @param tsList
     * @return List of FewsRegularTimeSeries that contains the input list objects casted.
     */
    public static List<FewsRegularTimeSeries> convertRegularTimeSeriesToFewsRegularTimeSeries(List<RegularTimeSeries> tsList)
    {
        ArrayList<FewsRegularTimeSeries> results = new ArrayList<FewsRegularTimeSeries>();
        for(RegularTimeSeries ts: tsList)
        {
            results.add((FewsRegularTimeSeries)ts);
        }
        return results;
    }

    public static void removeMissingValuesFromTheBeginning(RegularTimeSeries ts)
    {
        int newStartIndex;
        for(newStartIndex = 0; newStartIndex < ts.getMeasurementCount(); newStartIndex++)
        {
            if(ts.getMeasurementByIndex(newStartIndex).getValue() != ts.getMissingValue())
            {
                break;
            }
        }
        ts.trimTimeSeriesAtStart(ts.getMeasurementTimeByIndex(newStartIndex));
    }

    public static void removeMissingValuesFromTheEnd(RegularTimeSeries ts)
    {
        int newLastIndex;
        for(newLastIndex = ts.getMeasurementCount() - 1; newLastIndex >= 0; newLastIndex--)
        {
            if(ts.getMeasurementByIndex(newLastIndex).getValue() != ts.getMissingValue())
            {
                break;
            }
        }
        ts.trimTimeSeriesAtEnd(ts.getMeasurementTimeByIndex(newLastIndex));
    }

    public static void removeMissingValuesFromBeginningAndEnd(RegularTimeSeries ts)
    {
        removeMissingValuesFromTheBeginning(ts);
        removeMissingValuesFromTheEnd(ts);
    }
}
