package ohd.hseb.hefs.utils.status;

import javax.swing.ImageIcon;

import ohd.hseb.hefs.utils.tools.IconTools;

public enum BooleanStatus implements StatusIndicator
{
    COMPLETE(true, "checkMark", "This step is complete."), /**/
    NEEDS_UPDATE(null, "yellowExclamation", "Inputs have changed since this step was last completed."), /**/
    MISSING(false, "redX", "This step has not been performed.");

    private final Boolean _asBoolean;
    private final ImageIcon _icon;
    private String _description;

    private BooleanStatus(final Boolean asBoolean, final String iconName, final String description)
    {
        _asBoolean = asBoolean;
        _icon = IconTools.getHSEBIcon(iconName);
        _description = description;
    }

    public static BooleanStatus get(final Boolean b)
    {
        if(b == null)
        {
            return NEEDS_UPDATE;
        }
        else if(b)
        {
            return COMPLETE;
        }
        else
        {
            return MISSING;
        }
    }

    public void setDescription(final String description)
    {
        _description = description;
    }

    @Override
    public boolean canBePrepared()
    {
        return true;
    }

    @Override
    public Boolean toBoolean()
    {
        return _asBoolean;
    }

    @Override
    public boolean isReady()
    {
        return this.equals(COMPLETE);
    }

    @Override
    public boolean exists()
    {
        return !this.equals(MISSING);
    }

    @Override
    public ImageIcon getIcon()
    {
        return _icon;
    }

    @Override
    public String getDescription()
    {
        return _description;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return true;
    }

}
