package ohd.hseb.hefs.utils.status;

import javax.swing.Icon;


/**
 * A {@link StatusIndicator} that always returns a false for {@link #isReady()}, {@link #exists()},
 * {@link #canBePrepared()}, and {@link #includeInRowReadinessCheck()}. The icon is also null and {@link #toBoolean()}
 * always returns false. This is useful as a place holder for an abstract class that requires returning a
 * StatusIndicator.
 * 
 * @author Hank.Herr
 */
public final class NullStatusIndicator implements StatusIndicator
{
    public static final NullStatusIndicator INSTANCE = new NullStatusIndicator();

    private NullStatusIndicator()
    {
    }

    @Override
    public boolean isReady()
    {
        return false;
    }

    @Override
    public boolean exists()
    {
        return false;
    }

    @Override
    public boolean canBePrepared()
    {
        return false;
    }

    @Override
    public Icon getIcon()
    {
        return null;
    }

    @Override
    public String getDescription()
    {
        return "ERROR: This status has not been specified.";
    }

    @Override
    public Boolean toBoolean()
    {
        return false;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return false;
    }

}
