package ohd.hseb.hefs.utils.status;

import javax.swing.Icon;

import ohd.hseb.hefs.utils.gui.jtable.buttons.SelectUnreadyRowsButton;

/**
 * Generic interface indicating status.
 * 
 * @author Hank.Herr
 */
public interface StatusIndicator
{
    /**
     * @return True if whatever it is used for is 'ready'.
     */
    public boolean isReady();

    /**
     * @return A flag that can be used to indicate if something exists. For example, it may indicate if a group is
     *         defined, or a file has been created, and so forth.
     */
    public boolean exists();

    /**
     * @return True if all necessary inputs required to make whatever this is used for 'ready' are in place.
     */
    public boolean canBePrepared();

    /**
     * @return The icon to use for the status indicator. It should be one of blueCheckMark.png, checkMark.png, redX.png,
     *         or yellowExclamation.png under nonsrc/hefsicons.
     */
    public Icon getIcon();

    /**
     * @return Tool tip to use for the created icon.
     */
    public String getDescription();

    /**
     * Converts this to a {@link Boolean#}.
     * 
     * @return
     */
    public Boolean toBoolean();

    /**
     * @return True if the row is to be used in a row readiness check. False otherwise. This is used, for example, by
     *         the {@link SelectUnreadyRowsButton}.
     */
    public boolean includeInRowReadinessCheck();
}
