package ohd.hseb.hefs.utils.status;

import javax.swing.Icon;
import javax.swing.JTable;

import ohd.hseb.hefs.utils.gui.jtable.renderers.JLabelTableCellRenderer;
import ohd.hseb.hefs.utils.tools.IconTools;

/**
 * A {@link StatusIndicator} used to mark a wait/working/running status. It used to use an animated icon, but when
 * displayed in a {@link JTable} it had a habit of stopping its animation after a while; see
 * {@link JLabelTableCellRenderer}.
 * 
 * @author hankherr
 */
public class WorkingStatus implements StatusIndicator
{
    private final String _description;

    public WorkingStatus(final String description)
    {
        _description = description;
    }

    @Override
    public boolean isReady()
    {
        return false;
    }

    @Override
    public boolean exists()
    {
        return false;
    }

    @Override
    public boolean canBePrepared()
    {
        return false;
    }

    @Override
    public Icon getIcon()
    {
        return IconTools.getHSEBIcon("wait16x16");
    }

    @Override
    public String getDescription()
    {
        return _description;
    }

    @Override
    public Boolean toBoolean()
    {
        return null;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return false;
    }

}
