package ohd.hseb.hefs.utils.tools;

import java.util.Collection;

import com.google.common.base.Predicate;

/**
 * Functions related to collections.
 * 
 * @author Alexander.Garbarino
 */
public abstract class CollectionFunctions
{
    /**
     * {@link Predicate} applicable to any {@link Collection} where {@link Predicate#apply(Object)} returns true if the
     * provided input is empty.
     */
    public static final Predicate<Collection<?>> isEmpty = new Predicate<Collection<?>>()
    {
        @Override
        public boolean apply(Collection<?> input)
        {
            return input.isEmpty();
        }
    };
}
