package ohd.hseb.hefs.utils.tools;

import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.SwingUtilities;

public abstract class FocusOwnerTracker implements PropertyChangeListener
{
    private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";

    private final KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    private final Component comp;
    private boolean inside;

    public FocusOwnerTracker(Component comp)
    {
        this.comp = comp;
    }

    public boolean isFocusInside()
    {
        return isFocusInside(false);
    }

    private boolean isFocusInside(boolean find)
    {
        if(!find)
            return inside;

        Component c = focusManager.getPermanentFocusOwner();
        while(c != null)
        {
            if(c == comp)
            {
                return true;
            }
            else if((c instanceof Window) || (c instanceof Applet && c.getParent() == null))
            {
                if(c == SwingUtilities.getRoot(comp))
                {
                    return false;
                }
                break;
            }
            c = c.getParent();
        }
        return false;
    }

    public void start()
    {
        focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
        inside = isFocusInside(true);
    }

    public void stop()
    {
        focusManager.removePropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt)
    {
        System.out.println("####>> FOCUS EVENT RECEIVED: " + evt.getPropertyName() + ": " + evt.getOldValue() + " -> "
            + evt.getNewValue());
        boolean inside = isFocusInside(true);
        if(this.inside != inside)
        {
            if(inside)
                focusGained();
            else
                focusLost();
            this.inside = inside;
        }
    }

    public abstract void focusLost();

    public abstract void focusGained();
}
