package ohd.hseb.hefs.utils.tools;

import com.google.common.base.Function;

/**
 * Integer based {@link Function} instances.
 * 
 * @author Alexander.Garbarino
 */
public abstract class IntegerFunctions
{
    /**
     * {@link Function} mapping a {@link String} to an {@link Integer} returns {@link Integer#valueOf(String)} for the
     * given string. Function may throw a {@link NumberFormatException}.
     */
    public static final Function<String, Integer> valueOf = new Function<String, Integer>()
    {
        @Override
        public Integer apply(String input)
        {
            return Integer.valueOf(input);
        }
    };
}
