package ohd.hseb.hefs.utils.tools;

import static com.google.common.collect.Lists.newArrayList;

import java.util.Iterator;

import com.google.common.collect.Iterables;

public abstract class IterableTools
{
    /**
     * Creates a new iterable with {@code element} prepended to {@code iterable}.
     * 
     * @param <E> Element type of {@code iterable}
     * @param element The element to add to the front of the {@code iterable}.
     * @param iterable The current {@code iterable} contents.
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <E> Iterable<E> concat(final E element, final Iterable<? extends E> iterable)
    {
        return Iterables.concat(newArrayList(element), iterable);
    }

    /**
     * @param <E> The type of the {@link Iterable}.
     * @param iterable The iterable list.
     * @return The first item in the list.
     */
    public static <E> E first(final Iterable<E> iterable)
    {
        return iterable.iterator().next();
    }

    /**
     * @param <E> The type of the {@link Iterable}.
     * @param iterable The iterable list.
     * @return The last item in the list.
     */
    public static <E> E last(final Iterable<E> iterable)
    {
        final Iterator<E> iter = iterable.iterator();
        E result = null;
        while(iter.hasNext())
        {
            result = iter.next();
        }
        return result;
    }
}
