package ohd.hseb.hefs.utils.tools;

import com.google.common.base.Function;

/**
 * General {@link Function} instances related to Objects.
 * 
 * @author Hank.Herr
 */
public abstract class ObjectFunctions
{
    /**
     * {@link Function} where apply returns the {@link Object#toString()}.
     */
    public static final Function<Object, String> toString = new Function<Object, String>()
    {
        @Override
        public String apply(Object input)
        {
            return input.toString();
        }
    };

    /**
     * {@link Function} where apply returns the {@link Object#hashCode()}.
     */
    public static final Function<Object, Integer> hashCode = new Function<Object, Integer>()
    {
        @Override
        public Integer apply(Object input)
        {
            return input.hashCode();
        }
    };

    /**
     * {@link Function} where apply returns the {@link Object#getClass()}.
     */
    public static final Function<Object, Class<?>> getClass = new Function<Object, Class<?>>()
    {
        @Override
        public Class<?> apply(Object input)
        {
            return input.getClass();
        }
    };
}
