package ohd.hseb.hefs.utils.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


/**
 * Provides generic tools related to processes. The {@link LogLevel} enumeration is defined internally to this class.
 * 
 * @author hankherr
 */
public abstract class ProcessTools
{
    private static final Logger LOG = LogManager.getLogger(ProcessTools.class);

    /**
     * Referenced as "ProcessTools.LogLevel.DEBUG", for example.
     */
    public static enum LogLevel
    {
        DEBUG, INFO, ERROR;
    }

    /**
     * Outputs a stream created by a process to log4j. This does not close the provided stream!
     * 
     * @param stream The stream to output, either the stdout or stderr associated with a process.
     * @param debug True if the output should be debug messages, false for info level messages.
     * @throws IOException
     */
    public static void outputProcessOutputToLog4j(final InputStream stream, final LogLevel level) throws IOException
    {
        final InputStreamReader reader = new InputStreamReader(stream);
        final BufferedReader bufferedReader = new BufferedReader(reader);

        //Read the initial line and loop through it line by line.
        String currentLine = bufferedReader.readLine();
        while(currentLine != null)
        {
            if(level == LogLevel.DEBUG)
            {
                LOG.debug(currentLine);
            }
            else if(level == LogLevel.ERROR)
            {
                LOG.error(currentLine);
            }
            else
            {
                LOG.info(currentLine);
            }

            //Read the next line.
            currentLine = bufferedReader.readLine();
        }
    }
}
